package com.zzwtec.third.model.basedata.dto;

/**
 * 小区个性化配置
 * @author 邓燎燕
 *
 */
public class CommunityConfigDTO {

	private String id;
	/**
	 * 小区开通功能<br>
	 * JSON结构，如["feedback"]
	 */
	private String services;
	/**
	 * 设备首页个性化横屏图片<br>
	 * 文件存储表的id
	 */
	private String deviceImgCross;
	/**
	 * 设备首页个性化竖屏图片<br>
	 * 文件存储表的id
	 */
	private String deviceImgVertical;
	/**
	 * 小区设备类型<br>
	 * JSON结构，如{"doorbell":0,"enclosure":0}
	 */
	private String machineType;
	/**
	 * 门口机设置<br>
	 * Json结构，结构是{"lockType":"electron"}
	 */
	private String doorbellConfigure;
	/**
	 * 围墙机设置<br>
	 * Json结构，结构是{"lockType":"electron"}
	 */
	private String enclosureConfigure;
	/**
	 * 推送配置<br>
	 * JSON结构，如{"jpush":{"package":"包名","AppKey":"AppKey","MasterSecret":"MasterSecret"},"yunba":{"package":"包名","Appkey":"Appkey","SecretKey":"SecretKey"}}
	 */
	private String pushConfigure;
	/**
	 * 便民电话<br>
	 * JSON结构，[{"type":"类别","list":[{"msg":"显示内容","phone":"电话号码"}]}]
	 */
	private String telephone;
	/**
	 * 车场配置<br>
	 * Json结构，结构是{"type":"车场类型","parkId":"车场id"}
	 * 车场类型 0表示智之屋车场平台、1表示深圳广汇通停车系统、2表示科托停车系统-重庆停车信息联网标准
	 */
	private String parkingConfigure;
	private Boolean deletec;
	private String remark;
	/**
	 * 创建时间
	 */
	private Long createTime;
	/**
	 * 更新时间
	 */
	private Long updateTime;


	@Override
	public String toString() {
		return "CommunityConfigDTO{" +
				"id='" + id + '\'' +
				", services='" + services + '\'' +
				", deviceImgCross='" + deviceImgCross + '\'' +
				", deviceImgVertical='" + deviceImgVertical + '\'' +
				", machineType='" + machineType + '\'' +
				", doorbellConfigure='" + doorbellConfigure + '\'' +
				", enclosureConfigure='" + enclosureConfigure + '\'' +
				", pushConfigure='" + pushConfigure + '\'' +
				", telephone='" + telephone + '\'' +
				", parkingConfigure='" + parkingConfigure + '\'' +
				", deletec=" + deletec +
				", remark='" + remark + '\'' +
				", createTime=" + createTime +
				", updateTime=" + updateTime +
				'}';
	}

	public String getParkingConfigure() {
		return parkingConfigure;
	}

	public void setParkingConfigure(String parkingConfigure) {
		this.parkingConfigure = parkingConfigure;
	}

	public void setId(String id){
		this.id = id;
	}
	
	public String getId(){
		return this.id;
	}
	
	public void setMachineType(String machineType){		 
		this.machineType = machineType;
	}
	
	public String getMachineType(){
		return this.machineType;
	}
	
	public void setServices(String services){		 
		this.services = services;
	}
	
	public String getServices(){
		return this.services;
	}

	public void setDeviceImgCross(String deviceImgCross){
		this.deviceImgCross = deviceImgCross;
	}

	public String getDeviceImgCross(){
		return this.deviceImgCross;
	}
	public void setDeviceImgVertical(String deviceImgVertical){
		this.deviceImgVertical = deviceImgVertical;
	}

	public String getDeviceImgVertical(){
		return this.deviceImgVertical;
	}
	
	public void setDoorbellConfigure(String doorbellConfigure){		 
		this.doorbellConfigure = doorbellConfigure;
	}
	
	public String getDoorbellConfigure(){
		return this.doorbellConfigure;
	}
	
	public void setEnclosureConfigure(String enclosureConfigure){		 
		this.enclosureConfigure = enclosureConfigure;
	}
	
	public String getEnclosureConfigure(){
		return this.enclosureConfigure;
	}
	
	public void setPushConfigure(String pushConfigure){
		this.pushConfigure = pushConfigure;
	}
	
	public String getPushConfigure(){
		return this.pushConfigure;
	}
	
	public void setTelephone(String telephone){		 
		this.telephone = telephone;
	}
	
	public String getTelephone(){
		return this.telephone;
	}
	
	public void setDeletec(Boolean deletec){
		this.deletec = deletec;
	}
	
	public Boolean isDeletec(){
		return this.deletec;
	}
	
	public void setRemark(String remark){		 
		this.remark = remark;
	}
	
	public String getRemark(){
		return this.remark;
	}

	public Boolean getDeletec() {
		return deletec;
	}

	public Long getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Long createTime) {
		this.createTime = createTime;
	}

	public Long getUpdateTime() {
		return updateTime;
	}

	public void setUpdateTime(Long updateTime) {
		this.updateTime = updateTime;
	}

}
