package com.zzwtec.third.model.basedata.dto;


import com.zzwtec.third.common.ComprehensiveManagerKey;
import com.zzwtec.third.model.LockType;
import com.zzwtec.third.utils.TimeUtil;

import java.util.EnumSet;
import java.util.List;

/**
 * create by Jomchen on 2018/4/16
 */
public class CmpTagDTO {

    public static final String SYSTEM_OWER_ID = "0"; // 系统标签的 ower_id 的值

    private Integer id;
    private String name;
    private String owerId;
    private Boolean deletec;
    private String remark;
    private Long createTime;
    private Long updateTime;

    /* ---------- 扩展字段 ------ */
    private ComprehensiveManagerKey.CountTypeEnum countTypeEnum;
    private Long localDateTime;
    private String communityId;
    private String buildId;
    private String userId;
    private LockType lockType;
    private List<String> communityIdList;
    private Boolean confirmZzw;		// 是否是智之屋

    public CmpTagDTO() {
    }

    public enum SystemTagEnum {
        ELDERLY(1, "老人"),
        CHILD(2, "小孩"),
        DISABLED(3, "残疾人"),
        PRISON_OUT_PRISONERS(4, "刑满释放人员")
        ;
        private Integer code;
        private String remark;
        SystemTagEnum(Integer code, String remark) {
            this.code = code;
            this.remark = remark;
        }

        public Integer getCode() {
            return code;
        }
        public String getRemark() {
            return remark;
        }
    }

    public static SystemTagEnum getSystemTagEnum(Integer code) {
        if (null == code) {
            return null;
        }

        EnumSet<SystemTagEnum> systemTagEnumEnumSet = EnumSet.allOf(SystemTagEnum.class);
        SystemTagEnum systemTagEnumTarget = null;
        for (SystemTagEnum s : systemTagEnumEnumSet) {
            if (s.getCode().intValue() == code.intValue()) {
                systemTagEnumTarget = s;
                break;
            }
        }
        return systemTagEnumTarget;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOwerId() {
        return owerId;
    }

    public void setOwerId(String owerId) {
        this.owerId = owerId;
    }

    public String getCommunityId() {
        return communityId;
    }

    public void setCommunityId(String communityId) {
        this.communityId = communityId;
    }

    public Boolean getDeletec() {
        return deletec;
    }

    public void setDeletec(Boolean deletec) {
        this.deletec = deletec;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public Long getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    public Long getLocalDateTime() {
        return localDateTime;
    }

    public void setLocalDateTime(Long localDateTime) {
        this.localDateTime = localDateTime;
    }

    public void setLocalDateTime(String localDateTime) {
        this.localDateTime = TimeUtil.timeStr2Long(localDateTime);
    }

    public ComprehensiveManagerKey.CountTypeEnum getCountTypeEnum() {
        return countTypeEnum;
    }

    public void setCountTypeEnum(ComprehensiveManagerKey.CountTypeEnum countTypeEnum) {
        this.countTypeEnum = countTypeEnum;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public LockType getLockType() {
        return lockType;
    }

    public void setLockType(LockType lockType) {
        this.lockType = lockType;
    }

    public String getBuildId() {
        return buildId;
    }

    public void setBuildId(String buildId) {
        this.buildId = buildId;
    }

    public List<String> getCommunityIdList() {
        return communityIdList;
    }

    public void setCommunityIdList(List<String> communityIdList) {
        this.communityIdList = communityIdList;
    }

    public Boolean getConfirmZzw() {
        return confirmZzw;
    }

    public void setConfirmZzw(Boolean confirmZzw) {
        this.confirmZzw = confirmZzw;
    }
}
