package com.zzwtec.third.model.basedata.dto;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 房间
 * @author 邓燎燕
 *
 */
public class CellDTO {

    /**
     * id
     */
	private String id;
    /**
     * ids
     */
    private String[] ids;
    /**
     * 名称
     */
    private String name;
    /**
     * 门牌 4位，如0301
     */
    private String num;
	/**
	 * 位置
	 */
	private String address;
	/**
	 * 呼叫号码
	 */
	private String callphone;
	/**
	 * 是否呼叫
	 */
	private Boolean cancall;
    /**
     * 是否已删除
     */
	private Boolean deletec;
    /**
     * 备注
     */
	private String remark;


	/**
	 * 户主id
	 */
	private String userId;
    /**
     * 户主名称
     */
	private String userName;
    /**
     * 户主手机
     */
	private String loginPhone;


    /**
     * 楼栋id
     */
    private String buildId;
    /**
     * 楼栋门牌
     */
    private String buildNum;
    /**
     * 楼栋名称
     */
    private String buildName;
    /**
     * 小区id
     */
	private String communitId;
    /**
     * 小区名称
     */
    private String communitName;
    /**
     * 房间编号(上海智能安防社区)
     */
    private String smartCellCode;
    /**
	 * 创建时间
	 */
	private Long createTime;
	/**
	 * 更新时间
	 */
	private Long updateTime;


    /**
	 * 当页页码
	 */
	private Integer page;
	/**
	 * 每页记录数
	 */
	private Integer pageNum;

	/* ---------- 扩展属性 ---------- */
	private String sysUserId;   // 管理员id
    private UserDTO[] userArray;
	
	private boolean noMaster;

	private String masterUserId; // 此cell在user_cell表中查到的户主id

	public String getMasterUserId() {
		return masterUserId;
	}

	public void setMasterUserId(String masterUserId) {
		this.masterUserId = masterUserId;
	}

	public String getId() {
        return id;
    }

    public CellDTO setId(String id) {
        this.id = id;
        return this;
    }

    public String[] getIds() {
        return ids;
    }

    public CellDTO setIds(String[] ids) {
        this.ids = ids;
        return this;
    }

    public String getName() {
        return name;
    }

    public CellDTO setName(String name) {
        this.name = name;
        return this;
    }

    public String getNum() {
        return num;
    }

    public CellDTO setNum(String num) {
        this.num = num;
        return this;
    }

    public String getAddress() {
        return address;
    }

    public CellDTO setAddress(String address) {
        this.address = address;
        return this;
    }

    public String getCallphone() {
        return callphone;
    }

    public CellDTO setCallphone(String callphone) {
        this.callphone = callphone;
        return this;
    }

    public Boolean isCancall() {
        return cancall;
    }

    public CellDTO setCancall(Boolean cancall) {
        this.cancall = cancall;
        return this;
    }

    public Boolean isDeletec() {
        return deletec;
    }

    public CellDTO setDeletec(Boolean deletec) {
        this.deletec = deletec;
        return this;
    }

    public String getRemark() {
        return remark;
    }

    public CellDTO setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public String getUserId() {
        return userId;
    }

    public CellDTO setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String getUserName() {
        return userName;
    }

    public CellDTO setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public String getLoginPhone() {
        return loginPhone;
    }

    public CellDTO setLoginPhone(String loginPhone) {
        this.loginPhone = loginPhone;
        return this;
    }

    public String getBuildId() {
        return buildId;
    }

    public CellDTO setBuildId(String buildId) {
        this.buildId = buildId;
        return this;
    }

    public String getBuildNum() {
        return buildNum;
    }

    public CellDTO setBuildNum(String buildNum) {
        this.buildNum = buildNum;
        return this;
    }

    public String getBuildName() {
        return buildName;
    }

    public CellDTO setBuildName(String buildName) {
        this.buildName = buildName;
        return this;
    }

    public String getCommunitId() {
        return communitId;
    }

    public CellDTO setCommunitId(String communitId) {
        this.communitId = communitId;
        return this;
    }

    public String getCommunitName() {
        return communitName;
    }

    public CellDTO setCommunitName(String communitName) {
        this.communitName = communitName;
        return this;
    }


    public String getSmartCellCode() {
        return smartCellCode;
    }

    public void setSmartCellCode(String smartCellCode) {
        this.smartCellCode = smartCellCode;
    }

    public Long getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Long createTime) {
		this.createTime = createTime;
	}

	public Long getUpdateTime() {
		return updateTime;
	}

	public void setUpdateTime(Long updateTime) {
		this.updateTime = updateTime;
	}

	public Boolean getDeletec() {
		return deletec;
	}

	public Integer getPage() {
        return page;
    }

    public CellDTO setPage(Integer page) {
        this.page = page;
        return this;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public CellDTO setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
        return this;
    }

    public String getSysUserId() {
        return sysUserId;
    }

    public CellDTO setSysUserId(String sysUserId) {
        this.sysUserId = sysUserId;
        return this;
    }
    
    

    public boolean isNoMaster() {
		return noMaster;
	}

	public void setNoMaster(boolean noMaster) {
		this.noMaster = noMaster;
	}

    public UserDTO[] getUserArray() {
        return userArray;
    }

    public void setUserArray(UserDTO[] userArray) {
        this.userArray = userArray;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
