package com.zzwtec.third.model.basedata.dto;

public class BuildDTO {

    private String[] ids;
    /**
     * 小区ID
     */
    private String communityId;
    /**
     * 楼栋ID
     */
    private String id;
    /**
     * 位置
     */
    private String address;
    /**
     * 标识是否逻辑删除 0=false:逻辑未删除；1=true:逻辑已删除（默认为0）
     */
    private Boolean deletec;
    /**
     * 纬度
     */
    private Double latitude;
    /**
     * 经度
     */
    private Double longitude;
    /**
     * 名称
     */
    private String name;
    /**
     * 编号 4位，如：0001
     */
    private String num;
    /**
     * 备注
     */
    private String remark;
    /**
     * 创建时间
     */
    private Long createTime;
    /**
     * 更新时间
     */
    private Long updateTime;

    /**
     * 当页页码
     */
    private Integer page;
    /**
     * 每页记录数
     */
    private Integer pageNum;
    /**
     * 小区名字
     */
    private String communityName;

    @Override
    public String toString() {
        String idsStr = null;
        if (ids != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ids.length; i++) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(ids[i]);
            }
            idsStr = sb.toString();
        }
        return "BuildDTO [ids=" + idsStr + ", communityId=" + communityId
                + ", id=" + id + ", name=" + name
                + ", num=" + num + ", address=" + address
                + ", longitude=" + longitude + ", latitude=" + latitude
                + ", deletec=" + deletec + ", remark=" + remark
                + ", page=" + page + ", pageNum=" + pageNum + ", communityName=" + communityName
                + ", createTime=" + createTime
                + ", updateTime=" + updateTime
                + "]";
    }

    public String[] getIds() {
        return ids;
    }

    public void setIds(String[] ids) {
        this.ids = ids;
    }

    public String getCommunityId() {
        return communityId;
    }

    public void setCommunityId(String communityId) {
        this.communityId = communityId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Boolean getDeletec() {
        return deletec;
    }

    public void setDeletec(Boolean deletec) {
        this.deletec = deletec;
    }

    public Double getLatitude() {
        return latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public Double getLongitude() {
        return longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNum() {
        return num;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public Long getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public String getCommunityName() {
        return communityName;
    }

    public void setCommunityName(String communityName) {
        this.communityName = communityName;
    }
}
