package com.zzwtec.third.model;

import java.util.EnumSet;

/**
 * create by Jomchen on 2018/12/4
 */
public enum UserType {

    // 0表示普通用户，1表示总系统管理员(系统用户)，2表示广告管理员，3表示物业管理员(系统用户)

    /**
     * 普通用户 0
     */
    USER(0,"普通用户"),
    /**
     * 总系统管理员(系统用户) 1
     */
    SYSUSER(1,"系统用户"),
    /**
     * 广告管理员 2
     */
    ADUSER(2,"广告管理员"),
    /**
     * 物业管理员(系统用户) 3
     */
    SYSUSER_PROPERTY(3,"物业管理员"),
    /**
     * 4 未知
     */
    WORKER_UNKNOWN(4,"未知"),
    /**
     * 5保安
     */
    WORKER_SECURITY(5,"保安"),
    /**
     * 6清洁工
     */
    WORKER_CLEANER(6,"清洁工"),
    /**
     * 7修理工
     */
    WORKER_REPAIRMAN(7,"修理工"),
    /**
     * 8绿化工
     */
    WORKER_GREEN_CHEMICAL(8,"绿化工"),
    /**
     * 9工作人员 小区管理员
     */
    WORKER_ADMIN(9,"工作人员，小区管理员"),
    /**
     * 10综治管理员
     */
    CMP_ADMIN(10,"综治管理员");

    private int code;
    private String message;

    UserType(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public UserType getUserType(int code) {
        EnumSet<UserType> enumSet = EnumSet.allOf(UserType.class);
        for (UserType u : enumSet) {
            if (u.getCode() == code) {
                return u;
            }
        }
        return null;
    }

}
