package com.zzwtec.third.model;

/**
 * 用户与房间关系类型
 * @author 邓燎燕
 *
 */
public enum UserCellType {
	/**
	 * 户主 1
	 */
	MASTER,
	/**
	 * 成员 2
	 */
	MEMBER,
	/**
	 * 租客 3
	 */
	TENANT;

	@Override
	public String toString() {
		return String.valueOf(getUserCellType(this));
	}

	public static int getUserCellType(UserCellType userCellType){
		switch (userCellType){
			case MASTER: return 1;
			case MEMBER: return 2;
			case TENANT:return 3;
			default: return -1;
		}
	}

	public static UserCellType getUserCellType(int userCellType){
		switch (userCellType){
			case 1: return MASTER;
			case 2: return MEMBER;
			case 3: return TENANT;
			default: return null;
		}
	}

	public static UserCellType getUserCellType(String name){
		return UserCellType.valueOf(name);
	}

	public static String getUserCellTypeName(int userCellType){
		switch (userCellType){
			case 1: return "户主";
			case 2: return "成员";
			case 3: return "租客";
			default: return null;
		}
	}
}
