package com.zzwtec.third.model;

/**
 * 开锁方式
 *
 * @author dengliaoyan
 * @create 2017/8/4
 */
public enum OpenType {
    // 开锁方式，0表示未知，1表示门卡开锁，2表示呼叫开锁，3表示密码开锁，4表示手机NFC开锁，5表示近距离wifi开锁，6表示近距离蓝牙开锁，7表示远距离开锁，8表示微信开锁，9表示临时密码开锁，10表示人脸识别开锁，11表示二维码开锁，12表示快照开锁',13表示身份证开锁
    /**
     * 未知 0表示
     */
	UNKNOWN,
    /**
     * 门卡开锁 1表示
     */
	DOORCARD,
    /**
     * 呼叫开锁 2表示
     */
    CALL,
    /**
     * 密码开锁 3表示
     */
    PASSWORD,
    /**
     * 手机NFC开锁 4表示
     */
    NFC,
    /**
     * 近距离wifi开锁 5表示
     */
    WIFI,
    /**
     * 近距离蓝牙开锁 6表示
     */
    BLUETOOTH,
    /**
     * 远距离开锁 7表示
     */
    REMOTE,
    /**
     * 微信开锁 8表示
     */
    WECHAT,
    /**
     * 临时密码开锁 9表示
     */
    TEMP_PASSWORD,
    /**
     * 人脸识别开锁 10表示
     */
    FACE_RECOGNITION,
    /**
     * 二维码开锁 11表示
     */
    QR_CODE,
    /**
     * 快照开锁 12表示
     */
    SNAPSHOT,
    /**
     * 身份证开锁 13表示
     */
    IDCARD,
    /**
     * 门内开关 14
     * */
    INSIDE_DOOR,
    /**
     * 消防报警 15
     * */
    FIRE_ALARM,
    /**
     * 三方开锁 16
     */
    THIRD_OPEN,
    /**
     * 人证合一 17
     */
    IDENTIFY_FACE,
    /**
     * 访客白名单 18
     */
    VISITOR
    ;

    @Override
    public String toString() {
        return String.valueOf(getOpenType(this));
    }

    public static int getOpenType(OpenType openType){
        switch (openType){
            case UNKNOWN: return 0;
            case DOORCARD: return 1;
            case CALL: return 2;
            case PASSWORD: return 3;
            case NFC: return 4;
            case WIFI: return 5;
            case BLUETOOTH: return 6;
            case REMOTE: return 7;
            case WECHAT: return 8;
            case TEMP_PASSWORD: return 9;
            case FACE_RECOGNITION: return 10;
            case QR_CODE: return 11;
            case SNAPSHOT: return 12;
            case IDCARD:return 13;
            case INSIDE_DOOR: return 14;
            case FIRE_ALARM: return 15;
            case THIRD_OPEN: return 16;
            case IDENTIFY_FACE: return 17;
            case VISITOR: return 18;
            
            default: return -1;
        }
    }

    public static OpenType getOpenType(String name){
        return OpenType.valueOf(name);
    }

    public static OpenType getOpenType(int openType){
        switch (openType){
            case 0: return UNKNOWN;
            case 1: return DOORCARD;
            case 2: return CALL;
            case 3: return PASSWORD;
            case 4: return NFC;
            case 5: return WIFI;
            case 6: return BLUETOOTH;
            case 7: return REMOTE;
            case 8: return WECHAT;
            case 9: return TEMP_PASSWORD;
            case 10: return FACE_RECOGNITION;
            case 11: return QR_CODE;
            case 12: return SNAPSHOT;
            case 13: return IDCARD;
            case 14: return INSIDE_DOOR;
            case 15: return FIRE_ALARM;
            case 16: return THIRD_OPEN;
            case 17: return IDENTIFY_FACE;
            case 18: return VISITOR;
            default: return null;
        }
    }

    public static String getOpenTypeName(OpenType openType){
        switch (openType){
            case UNKNOWN: return "未知";
            case DOORCARD: return "门卡开锁";
            case CALL: return "呼叫开锁";
            case PASSWORD: return "密码开锁";
            case NFC: return "手机NFC开锁";
            case WIFI: return "近距离开锁";
            case BLUETOOTH: return "蓝牙开锁";
            //case BLUETOOTH: return "近距离蓝牙开锁";
            case REMOTE: return "远距离开锁";
            case WECHAT: return "微信开锁";
            case TEMP_PASSWORD: return "临时密码开锁";
            case FACE_RECOGNITION: return "人脸识别开锁";
            case QR_CODE: return "二维码开锁";
            case SNAPSHOT: return "快照开锁";
            case IDCARD:return "身份证开锁";
            case INSIDE_DOOR: return "门内开关";
            case FIRE_ALARM: return "消防报警";
            case THIRD_OPEN: return "三方开锁";
            case IDENTIFY_FACE: return "人证合一";
            case VISITOR: return "访客白名单";

            default: return "";
        }
    }

}
