package com.zzwtec.third.model;

import java.util.EnumSet;

/**
 * create by Jomchen on 2018/12/4
 */
public enum ObjType {


    //0表示智之屋 10表示省 11表示市 20表示物业 21表示小区 22表示楼栋 23表示房间 30表示广告 待补充

    /**
     * 智之屋 0表示
     */
    ZZW(0, "智之屋"),
    /**
     * 省 10表示
     */
    PROVINCE(10, "省"),
    /**
     * 市 11表示
     */
    CITY(11, "市"),
    /**
     * 物业 20表示
     */
    PROPERTY(20, "物业"),
    /**
     * 小区 21表示
     */
    COMMUNITY(21, "小区"),
    /**
     * 楼栋 22表示
     */
    BUILD(22, "楼栋"),
    /**
     * 房间 23表示
     */
    CELL(23, "房间"),
    /**
     * 门 24表示
     */
    DOOR(24, "门"),
    /**
     * 广告商 25表示
     */
    ADVERTISER(25, "广告商"),
    /**
     * 广告 30表示
     */
    AD(30, "广告");

    private int code;
    private String message;

    ObjType(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    /**
     * 根据编号获取对象
     */
    public ObjType getObjType(int code) {
        EnumSet<ObjType> enumSet = EnumSet.allOf(ObjType.class);
            for (ObjType o : enumSet) {
                if (o.getCode() == code) {
                    return o;
                }
            }

        return null;
    }

}
