package com.zzwtec.third.model;

/**
 * 门锁类型
 *
 * @author dengliaoyan
 * @create 2017/8/4
 */
public enum LockType {
    // 门锁类型，0表示未知，1表示门口机，2表示围墙机
    /**
     * 未知 0表示
     */
	UNKNOWN,
    /**
     * 门口机 1表示
     */
    DOORBELL,
    /**
     * 围墙机 2表示
     */
    ENCLOSURE;

    @Override
    public String toString() {
        return String.valueOf(getLockType(this));
    }

    public static int getLockType(LockType lockType){
        switch (lockType){
            case UNKNOWN: return 0;
            case DOORBELL: return 1;
            case ENCLOSURE: return 2;
            default: return -1;
        }
    }

    public static LockType getLockType(String name){
        return LockType.valueOf(name);
    }

    public static LockType getLockType(int lockType){
        switch (lockType){
            case 0: return UNKNOWN;
            case 1: return DOORBELL;
            case 2: return ENCLOSURE;
            default: return null;
        }
    }

}
