package com.zzwtec.third.model;

/**
 * 门类型
 *
 * @author dengliaoyan
 * @create 2017/8/2
 */
public enum DoorType {
    /**
     * 楼栋门 0
     */
    BUILD_DOOR,
    /**
     * 小区门 1
     */
    COMMUNITY_DOOR;

    @Override
    public String toString() {
        return String.valueOf(getDoorType(this));
    }

    public static int getDoorType(DoorType doorType){
        switch (doorType){
            case BUILD_DOOR: return 0;
            case COMMUNITY_DOOR: return 1;
            default: return -1;
        }
    }

    public static DoorType getDoorType(String name){
        return DoorType.valueOf(name);
    }

    public static DoorType getDoorType(int doorType){
        switch (doorType){
            case 0: return BUILD_DOOR;
            case 1: return COMMUNITY_DOOR;
            default: return null;
        }
    }
}
