package com.zzwtec.third.config.redis;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericToStringSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

/**
 * create by Jomchen on 2018/12/3
 */
@Configuration
public class RedisConfig {

    @SuppressWarnings("unchecked")
    @Bean("redisTemplate")
    public <V> RedisTemplate<String, V> redisTemplate(@Autowired RedisConnectionFactory connectionFactory) {
        RedisTemplate<String, V> redisTemplate = new RedisTemplate<>();
        redisTemplate.setConnectionFactory(connectionFactory);
        StringRedisSerializer keySerializer = new StringRedisSerializer();
        RedisSerializer<String> valSeializer = new GenericToStringSerializer(String.class);
        redisTemplate.setConnectionFactory(connectionFactory);
        redisTemplate.setKeySerializer(keySerializer);
        redisTemplate.setValueSerializer(valSeializer);
        redisTemplate.setHashKeySerializer(keySerializer);
        redisTemplate.setHashValueSerializer(valSeializer);
        return redisTemplate;
    }

    @SuppressWarnings("unchecked")
    @Bean("stringRedisTemplate")
    public RedisTemplate<String, String> stringRedisTemplate(@Autowired RedisConnectionFactory connectionFactory) {
        RedisTemplate<String, String> redisTemplate = new RedisTemplate<>();
        redisTemplate.setConnectionFactory(connectionFactory);
        StringRedisSerializer keySerializer = new StringRedisSerializer();
        RedisSerializer<String> valSeializer = new GenericToStringSerializer(String.class);
        redisTemplate.setConnectionFactory(connectionFactory);
        redisTemplate.setKeySerializer(keySerializer);
        redisTemplate.setValueSerializer(valSeializer);
        redisTemplate.setHashKeySerializer(keySerializer);
        redisTemplate.setHashValueSerializer(valSeializer);
        return redisTemplate;
    }

    @SuppressWarnings("unchecked")
    @Bean("integerRedisTemplate")
    public RedisTemplate<String, Integer> integerRedisTemplate(@Autowired RedisConnectionFactory connectionFactory) {
        RedisTemplate<String, Integer> redisTemplate = new RedisTemplate<>();
        redisTemplate.setConnectionFactory(connectionFactory);
        StringRedisSerializer keySerializer = new StringRedisSerializer();
        RedisSerializer<Integer> valSeializer = new GenericToStringSerializer(Integer.class);
        redisTemplate.setConnectionFactory(connectionFactory);
        redisTemplate.setKeySerializer(keySerializer);
        redisTemplate.setValueSerializer(valSeializer);
        redisTemplate.setHashKeySerializer(keySerializer);
        redisTemplate.setHashValueSerializer(valSeializer);
        return redisTemplate;
    }

}
