package com.zzwtec.third.config.beetl;

import org.beetl.core.resource.ClasspathResourceLoader;
import org.beetl.ext.spring.BeetlGroupUtilConfiguration;
import org.beetl.ext.spring.BeetlSpringViewResolver;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

/**
 * create by Jomchen on 2018/11/29
 */
@Configuration
public class BeetlConfiguration {
    @Bean(initMethod = "init", name = "beetlConfig")
    public BeetlGroupUtilConfiguration getBeetlGroupUtilConfiguration() {

        BeetlGroupUtilConfiguration beetlGroupUtilConfiguration = new BeetlGroupUtilConfiguration();
        try {
            /*ClasspathResourceLoader cploder = new ClasspathResourceLoader(
                    BeetlConfiguration.class.getClassLoader(),
                    "webapp"
            );*/

            ClasspathResourceLoader cploder = new ClasspathResourceLoader(
                    BeetlConfiguration.class.getClassLoader()
            );
            beetlGroupUtilConfiguration.setResourceLoader(cploder);
            beetlGroupUtilConfiguration.setTypeFormats(genTypeFormats());
            beetlGroupUtilConfiguration.setFunctions(getFunctions());
        } catch (Exception e) {
            e.printStackTrace();
        }

        // 读取配置文件信息
        //beetlGroupUtilConfiguration.setConfigFileResource(patternResolver.getResource("classpath:beetl.properties"));
		/* 以下代码千万别被打开
		Map<String, TagFactory> tagFactorys = new HashMap<String, TagFactory>();
		tagFactorys.put("permission", new BeanTagFactory());
		beetlGroupUtilConfiguration.setTagFactorys(tagFactorys);
		*/
        return beetlGroupUtilConfiguration;
    }


    private Map<String, org.beetl.core.Function> getFunctions() {
        Map<String, org.beetl.core.Function> functions = new HashMap<>();
        functions.put("LongTimeFormat", new LongTimeFormat());
        return functions;
    }

    private Map<Class<?>, org.beetl.core.Format> genTypeFormats() {
        Map<Class<?>, org.beetl.core.Format> typeFormats = new HashMap<>();
        typeFormats.put(LocalDateTime.class, new LocalDateTimeFormat());
        return typeFormats;
    }

}
