package com.zzwtec.third.common;

/**
 * create by Jomchen on 2018/12/4
 * 请求id
 */
public class RequestIdContext {

    private static final String REQUESTID_DEMO = "%s-%s";

    public static final InheritableThreadLocal<String> CONTEXT = new InheritableThreadLocal<>();

    /**
     * 生成上下文请求id
     */
    public static String generateRequestId() {
        return String.format(REQUESTID_DEMO, WebPrefixAndConstant.THIRD_CONTEXT, System.nanoTime());
    }

    /**
     * 获取上下文请求id
     */
    public static String getRequestId() {
        return CONTEXT.get();
    }

    /**
     * 设置上下文请求id
     */
    public static void setRequestId(String requestId) {
        CONTEXT.set(requestId);
    }

    /**
     * 删除上下文请求id
     */
    public static void removeRequestId() {
        CONTEXT.remove();
    }


}
