package com.zzwtec.third.common;

/**
 * 支持分页条
 * @author yangtonggan
 * @date 2016-3-16
 */
public class PageIndex {
	
	private long startindex;
	private long endindex;
	private long currentpage;
	private long totalpage;	
	
	public PageIndex(long startindex, long endindex, long currentpage, long totalpage) {
		this.startindex = startindex;
		this.endindex = endindex;
		this.currentpage = currentpage;
		this.totalpage = totalpage;
	}
	
	public long getCurrentpage() {
		return currentpage;
	}

	public void setCurrentpage(long currentpage) {
		this.currentpage = currentpage;
	}
	
	public long getTotalpage() {
		return totalpage;
	}
	public void setTotalpage(long totalpage) {
		this.totalpage = totalpage;
	}
	
	public long getStartindex() {
		return startindex;
	}
	public void setStartindex(long startindex) {
		this.startindex = startindex;
	}
	public long getEndindex() {
		return endindex;
	}
	public void setEndindex(long endindex) {
		this.endindex = endindex;
	}
	 
	public static PageIndex getPageIndex(long viewpagecount, int currentPage, long totalpage){
			long startpage = currentPage-(viewpagecount%2==0? viewpagecount/2-1 : viewpagecount/2);
			long endpage = currentPage+viewpagecount/2;
			if(startpage<1){
				startpage = 1;
				if(totalpage>=viewpagecount) endpage = viewpagecount;
				else endpage = totalpage;
			}
			if(endpage>totalpage){
				endpage = totalpage;
				if((endpage-viewpagecount)>0) startpage = endpage-viewpagecount+1;
				else startpage = 1;
			}
			return new PageIndex(startpage, endpage,currentPage,totalpage);		
	}
}
