package com.zzwtec.third.common;


import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * 分页添加查询
 * @author 邓燎燕
 *
 */
public class Page<T> {

	public static final int DEFAULT_PAGE = 1;
	public static final int DEFAULT_PAGE_NUM = 12;

	/**
     * 条件字段
     */
	private String[] searchFields;
    /**
     * 条件 如"like",">","<","=",等等。 <br/>
     * 条件拼凑语句: <br/>
     * searchFields[i]+" "+condition[i]+" "+searchValues[i]+" and "+searchFields[i+1]+" "+condition[i+1]+" "+searchValues[i+1]
     */
	private String[] condition;
    /**
     * 条件内容
     */
	private String[] searchValues;
    /**
     * 排序字段
     */
	private String orderField;
    /**
     * 排序方式
     */
	private OrderType orderType;
	/**
	 * 分组字段
	 */
	private String[] groupByFields;
	/**
	 * 是否使用 DISTINCT
	 */
	private Boolean distinct;
    /**
     * 当页页码
     */
	private Integer page;
    /**
     * 每页记录数
     */
	private Integer pageNum;
    /**
     * 总页数
     */
	private Long total=0L;
    /**
     * 总记录数
     */
	private Long rows=0L;
	/**
	 * 返回结果
	 */
	private List<T> data;


	/* ------------------------------------------------ 其它扩展属性 ------------------------------------------------ */

	private Map<String,List<String>> map;	// 用于登录账号记录权限信息
	private String SysUserId;				// 用户id
	private Boolean confirmZzw;				// 是否是智之屋
	private List<String> userIdList;		// 用户 id 集合
	private LocalDateTime localDateTime;    // 用于时间的调度
	private Integer alarmType;
	public Page() {
	}

	public Page(Long total, Long rows, List<T> data) {
		this.total = total;
		this.rows = rows;
		this.data = data;
	}

	public List<String> getUserIdList() { return userIdList; }

	public void setUserIdList(List<String> userIdList) { this.userIdList = userIdList; }

	public String getSysUserId() {
		return SysUserId;
	}
	public void setSysUserId(String sysUserId) {
		SysUserId = sysUserId;
	}
	public Map<String, List<String>> getMap() {
		return map;
	}
	public void setMap(Map<String, List<String>> map) {
		this.map = map;
	}
	public Boolean getConfirmZzw() { return confirmZzw; }
	public void setConfirmZzw(Boolean confirmZzw) { this.confirmZzw = confirmZzw; }

	public String[] getSearchFields() {
		return searchFields;
	}
	public String[] getCondition() {
		return condition;
	}
	public String[] getSearchValues() {
		return searchValues;
	}
	public String getOrderField() {
		return orderField;
	}
	public OrderType getOrderType() {
		return orderType;
	}
	public String[] getGroupByFields() {
		return groupByFields;
	}
	public Boolean isDistinct() {
		return distinct;
	}
	public Integer getPage() {
		return page;
	}
	public Integer getPageNum() {
		return pageNum;
	}
	public Long getTotal() {
		return total;
	}
	public Long getRows() {
		return rows;
	}
	public void setSearchFields(String[] searchFields) {
		this.searchFields = searchFields;
	}
	public void setCondition(String[] condition) {
		this.condition = condition;
	}
	public void setSearchValues(String[] searchValues) {
		this.searchValues = searchValues;
	}
	public void setOrderField(String orderField) {
		this.orderField = orderField;
	}
	public void setOrderType(String orderType) {
		this.orderType = OrderType.valueOf(orderType);
	}
	public void setOrderType(OrderType orderType) {
		this.orderType = orderType;
	}
	public void setGroupByFields(String[] groupByFields) {
		this.groupByFields = groupByFields;
	}
	public void setDistinct(Boolean distinct) {
		this.distinct = distinct;
	}
	public void setPage(int page) {
		this.page = page;
	}
	public void setPageNum(int pageNum) {
		this.pageNum = pageNum;
	}
	public void setTotal(long total) {
		this.total = total;
	}
	public void setRows(long rows) {
		this.rows = rows;
	}
	public List<T> getData() {
		return data;
	}
	public void setData(List<T> data) {
		this.data = data;
	}
	public LocalDateTime getLocalDateTime() { return localDateTime; }
	public void setLocalDateTime(LocalDateTime localDateTime) { this.localDateTime = localDateTime; }

	public Integer getAlarmType() {
		return alarmType;
	}

	public void setAlarmType(Integer alarmType) {
		this.alarmType = alarmType;
	}

	@Override
	public String toString() {
		return "Page{" +
				"searchFields=" + Arrays.toString(searchFields) +
				", condition=" + Arrays.toString(condition) +
				", searchValues=" + Arrays.toString(searchValues) +
				", orderField='" + orderField + '\'' +
				", orderType=" + orderType +
				", groupByFields=" + Arrays.toString(groupByFields) +
				", distinct=" + distinct +
				", page=" + page +
				", pageNum=" + pageNum +
				", total=" + total +
				", rows=" + rows +
				", data=" + data +
				", map=" + map +
				", SysUserId='" + SysUserId + '\'' +
				", confirmZzw=" + confirmZzw +
				", userIdList=" + userIdList +
				", localDateTime=" + localDateTime +
				", alarmType=" + alarmType +
				'}';
	}

	public static <E, T> Page<E> convert(Page<T> page, List<E> data) {
		Page<E> ePage = new Page<>();
		ePage.setRows(page.getRows());
		ePage.setTotal(page.getTotal());
		ePage.setPage(page.getPage());
		ePage.setPageNum(page.getPageNum());
		ePage.setData(data);
		return ePage;
	}
}
