package com.zzwtec.third.common;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * create by Jomchen on 2018/12/4
 * openapi 的请求地址
 */
@Component
public class OpenApiUrl {

//    private static final String URL_BEGIN = "http://10.0.0.222:8100/";
//    private static final String URL_BEGIN = "http://10.0.0.218:8100/";
//private static final String URL_BEGIN = "https://open.zzwtec.com/";


    // 物业登录
    @Value("${openapi.url.login}")
    private String loginUrl ;
    // 物业登出
    @Value("${openapi.url.login-out}")
    private String loginOutUrl ;

    @Value("${openapi.url.query-community-config-by-community-id}")
    private String communityQueryCommunityConfigByCommunityIdUrl ;
    //根据小区id查询小区信息
    @Value("${openapi.url.query-community-info}")
    private String communityQueryCommunityInfoUrl ;
    // 根据小区id查询所有楼栋id
    @Value("${openapi.url.query-all-build-id-by-community-id}")
    private String buildGetAllBuild ;

    // 根据楼栋id分页查询房间
    @Value("${openapi.url.query-cell-by-build-id}")
    private String cellGetCellByBuild ;
    //根据房间id查询房间
    @Value("${openapi.url.query-cell-by-cell-id}")
    private String cellGetCellByCellid ;
    //添加房间
    @Value("${openapi.url.add-cell}")
    private String cellAdd ;
    //修改房间
    @Value("${openapi.url.update-cell}")
    private String cellUpdate ;
    //删除房间
    @Value("${openapi.url.delete-cell-by-ids}")
    private String cellDelete ;

    //根据房间id查询住户和房间的关系
    @Value("${openapi.url.query-user-cell}")
    private String userCellQueryUserCellByCellId ;

    //删除住户房产
    @Value("${openapi.url.delete-user-cell-by-user-id-cell-id}")
    private String userDeleteUserCellByUserIdCellId ;

    @Value("${openapi.url.query-user-by-user-id}")
    private String userQueryUserByUserId;
    //添加住户
    @Value("${openapi.url.add-user-by-user-cell-info}")
    private String userAddUserByUserCell ;
    //修改住户
    @Value("${openapi.url.update-user-by-user-cell-info}")
    private String userUpdUserByUserCell ;

    // 根据小区id查询资讯列表
    @Value("${openapi.url.query-notice-by-community-id}")
    private String newsQueryNoticeByCommunityId ;
    // 根据资讯id查询资讯详情
    @Value("${openapi.url.query-notice-by-notice-id}")
    private String newsQueryNoticeByNoticeId ;


    // 根据小区id查询分页楼栋信息
    @Value("${openapi.url.query-build-by-community-id}")
    private String queryBuildPageUrl ;
    // 根据楼栋id查询楼栋信息
    @Value("${openapi.url.query-build-by-id}")
    private String queryBuildUrl ;
    // 添加楼栋信息
    @Value("${openapi.url.add-build}")
    private String addBuildUrl ;
    // 删除楼栋信息
    @Value("${openapi.url.delete-build-by-ids}")
    private String delBuildUrl ;
    // 修改楼栋信息
    @Value("${openapi.url.update-build}")
    private String updBuildUrl ;

    // 根据小区id或楼栋id分页获取门信息
    @Value("${openapi.url.query-page-door-by-community-id-or-build-id}")
    private String queryPageDoorUrl ;
    // 根据门id获取所有门信息
    @Value("${openapi.url.query-door-by-id}")
    private String queryDoorUrl ;
    // 修改门的remote状态
    @Value("${openapi.url.set-door-remote}")
    private String updDoorRemoteUrl ;

    public String getUserQueryUserByUserId() {
        return userQueryUserByUserId;
    }

    public String getLoginUrl() {
        return loginUrl;
    }

    public String getLoginOutUrl() {
        return loginOutUrl;
    }

    public String getCommunityQueryCommunityConfigByCommunityIdUrl() {
        return communityQueryCommunityConfigByCommunityIdUrl;
    }

    public String getCommunityQueryCommunityInfoUrl() {
        return communityQueryCommunityInfoUrl;
    }

    public String getBuildGetAllBuild() {
        return buildGetAllBuild;
    }

    public String getCellGetCellByBuild() {
        return cellGetCellByBuild;
    }

    public String getCellGetCellByCellid() {
        return cellGetCellByCellid;
    }

    public String getCellAdd() {
        return cellAdd;
    }

    public String getCellUpdate() {
        return cellUpdate;
    }

    public String getCellDelete() {
        return cellDelete;
    }

    public String getUserCellQueryUserCellByCellId() {
        return userCellQueryUserCellByCellId;
    }

    public String getUserDeleteUserCellByUserIdCellId() {
        return userDeleteUserCellByUserIdCellId;
    }

    public String getUserAddUserByUserCell() {
        return userAddUserByUserCell;
    }

    public String getUserUpdUserByUserCell() {
        return userUpdUserByUserCell;
    }

    public String getNewsQueryNoticeByCommunityId() {
        return newsQueryNoticeByCommunityId;
    }

    public String getNewsQueryNoticeByNoticeId() {
        return newsQueryNoticeByNoticeId;
    }

    public String getQueryBuildPageUrl() {
        return queryBuildPageUrl;
    }

    public String getQueryBuildUrl() {
        return queryBuildUrl;
    }

    public String getAddBuildUrl() {
        return addBuildUrl;
    }

    public String getDelBuildUrl() {
        return delBuildUrl;
    }

    public String getUpdBuildUrl() {
        return updBuildUrl;
    }

    public String getQueryPageDoorUrl() {
        return queryPageDoorUrl;
    }

    public String getQueryDoorUrl() {
        return queryDoorUrl;
    }

    public String getUpdDoorRemoteUrl() {
        return updDoorRemoteUrl;
    }
}
