package com.zzwtec.third.common;

import com.zzwtec.third.utils.StringUtil;

import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Random;

/**
 * create by Jomchen on 2018/12/3
 * cookie 处理类
 */
public class MyCaptchaResult {

    private static final String[] fontNames = {"Times New Roman","Arial","Cambria","SansSerif","nyala","Bell MT","Credit valley","Impact", Font.MONOSPACED};
    private static final int[] fontStyles = {Font.BOLD,Font.PLAIN,Font.ITALIC};
    private static final int[] fontSizes = {20,22,24};
    private String randomCodeKey ;

    private int img_width = 96;
    private int img_height = 35;

    public MyCaptchaResult(String randomKey) {
        if (StringUtil.isEmpty(randomKey))
            throw new IllegalArgumentException("randomKey can not be blank");
        randomCodeKey = randomKey;
    }
    public MyCaptchaResult(String randomKey, int width, int height) {
        if (StringUtil.isEmpty(randomKey))
            throw new IllegalArgumentException("randomKey can not be blank");
        randomCodeKey = randomKey;

        if (width <= 0 || height <= 0 ) {
            throw new IllegalArgumentException("Image width or height must be > 0");
        }
        this.img_width = width;
        this.img_height = height;
    }

    public void render(HttpServletResponse response) {
        BufferedImage image = new BufferedImage(img_width, img_height, BufferedImage.TYPE_INT_RGB);
        drawGraphic(image);
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0);
        response.setContentType("image/jpeg");

        ServletOutputStream sos = null;
        try {
            sos = response.getOutputStream();
            ImageIO.write(image, "jpeg", sos);
        } catch (Exception e) {
            throw new RuntimeException(e);
        } finally {
            if (sos != null)
                try {
                    sos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
        }
    }

    private void drawGraphic(BufferedImage image) {
        // 获取图形上下文
        Graphics g = image.createGraphics();
        // 生成随机类
        Random random = new Random();
        // 设定背景色

        g.setColor(new Color(193, 203, 219));
        g.fillRect(0, 0, img_width, img_height);

        char[] randoms = randomCodeKey.toCharArray();
        float w = 1.0f * (img_width-8)/randoms.length;
        // 取随机产生的认证码(img_randNumber位数字)
        for (int i = 0; i < randoms.length; i++) {
            g.setColor(new Color(235 + random.nextInt(20), 235 + random.nextInt(20), 235 + random.nextInt(20)));
            // 调用函数出来的颜色相同，可能是因为种子太接近，所以只能直接生成
            String fontName = fontNames[random.nextInt(fontNames.length)];
            int fontStyle = fontStyles[random.nextInt(fontStyles.length)];
            int fontSize =  fontSizes[random.nextInt(fontSizes.length)];
            g.setFont(new Font(fontName,fontStyle,fontSize));

            int x = (int)(4.0 + w * i);
            int y = 20 + random.nextInt(img_height-fontSize-4) ;
            g.drawChars(randoms, i, 1, x, y);
        }
        // 图象生效
        g.dispose();
    }

}
