package com.zzwtec.third.common;

import com.zzwtec.third.utils.BizException;
import com.zzwtec.third.utils.TimeUtil;
import org.apache.commons.lang.StringUtils;

import java.time.format.DateTimeFormatter;
import java.util.EnumSet;

/**
 * create by Jomchen on 2018/4/11
 */
public class ComprehensiveManagerKey {

    public static final String PREFIX = "cmp";
    public static final String INITIALIZE_PROGRESS_ZONGZHI = PREFIX + "-initialize-progress-zongzhi-%s";                                // 记录用于初始化进度
    public static final String GLOBAL_COMMUNITY_ID = "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC";                                      // 对智之屋统计时替换小区id的字符串,这个常量不可带“-”字符串(在解析时hashKey会用)
    public static final String UNKNOWN_BUILD_ID = "BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB";                                         // 楼栋id 为空时的补充，这个常量不可带“-”字符串(在解析hashKey会用)
    public static final String DEFAULT_DATE = "TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT";                                             // 用于替代时间字段,主要用于固定存储 户主/成员/租客 数
    public static final String BELONG_TO_SYSTEM_USER = "belong_to_system_user_id";                                               // 缓存属于非 user 表中的用户id
    public static final String BELONG_TO_SIMPLE_USER = "belong_to_simple_user_id";                                               // 缓存属于 user 表中 的用户id

    public static final String CMP_COMPREHENSIVE_STREAM_DEFAULT_INITIAL = "cmp_comprehensive_stream_default_initial";         // 综治平台的对 ComprehensiveManagerService 的初始化

    public static final String COMPREHENSIVE_MANAGER_ACTUAL_ABOUT_COMMUNITY_KEY = PREFIX + "-%s-%s-%s";                       // 有关小区的实时数据的 key 的格式模板
    public static final String COMPREHENSIVE_MANAGER_ACTUAL_ABOUT_BUILD_KEY = PREFIX + "-%s-%s-%s-%s";                        // 有关楼栋的的实时数据的 key 的格式模板

    public static final String COMPREHENSIVE_DEVICE_OPEN_TOTAL_NUM = PREFIX + "-%s-%s-%s";                                    // 有关小区中相应门的开门总次数
    public static final String COMPREHENSIVE_DEVICE_OPEN_DETAILED_NUM = PREFIX + "-%s-%s-%s-%s";                              // 相应门详细时间点的开门次数

    public static final String COMPREHENSIVE_TAG_FOR_USER_ON_COMMUNITY = PREFIX + "-%s-%s-%s";                                // 用户的系统标签 和 在相应小区中的非系统标签 的并集
    public static final String COMPREHENSIVE_ZZW_ALL_TAG_FOR_USER = PREFIX + "-zzw-%s-%s";                                    // 智之屋统计时用户所拥有的所有标签(包括系统标签和非系统标签)

    public static final DateTimeFormatter DATE_FOR_MATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    public static final DateTimeFormatter DATE_TIME_FOR_MATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");


    /**
     * 小区的综治平台统计
     */
    public enum CountTypeEnum {

        CACHE_ALL_TAG_OF_USER("cacheAllTagOfUser"),                                         // 缓存用户的所有标签(包括系统标签和非系统标签)
        CACHE_TAG_OF_CUSTOMER_AND_SYSTEM_FOR_USER("cacheTagOfCustomerAndSystemForUser"),    // 缓存用户的系统标签 和 用户在所在小区标签的并集

        COMPREHENSIVE_SUMMARY("comprehensiveSummary"),                                      // 综治平台汇总数据
        CUSTOMER_TAG_NUM("customerTagNum"),                                                 // 综治汇总非系统标签数
        DOORBELL_OPEN_NUM("doorbellOpenNum"),                                               // 综治汇总今日门口机总开门数
        ENCLOSURE_OPEN_NUM("enclosureOpenNum"),                                             // 综治汇总今日围墙机总开门数

        BUILD_AGE("buildAge"),                                                              // 今年小区年龄分布
        ACTUAL_PERSONNEL("actualPersonnel"),                                                // 实时人员通行数据

        DEVICE_OPEN_TOTAL_NUM("deviceOpenTotalNum"),                                        // 今日小区中的相应门的的开门总数
        DEVICE_OPEN_DETAILED_NUM("deviceOpenDetailedNum"),                                  // 今日小区中的相应门在详细时间点的开门总数

        TAG_THROUGH_MAP("tagThroughMap"),                                                   // 今日标签在所在小区门口机/围墙机的用户数集合
        TAG_COMMUNITY_THROUGH_MAP("tagCommunityThroughMap"),                                // 标签在小区门通行用户集合,存用户id
        TAG_BUILD_THROUGH_MAP("tagbuildthroughMap"),                                        // 标签在楼栋门通行用户集合,存用户id

        FOCUS_PASS_SET("focusPassSet"),                         // 今日重点布控人员、刑满释放通行，存用户id
        DISABILITY_PASS_SET("disabilityPassSet"),               // 今日残疾人通行，存用户id
        OLD_MAN_PASS_SET("oldManPassSet"),                      // 今日老人通行，存用户id
        CHILD_PASS_SET("childPassSet"),                         // 今日小孩通行，存用户id
        GENERAL_USER_SET("generalUserSet"),                     // 今日一般用户(没有标签的用户)通行，存用户id
        ACTIVE_USER_SET("activeUserSet"),                       // 今日活跃用户，存用户id
        TENANT_USER_SET("tenantUserSet"),                       // 小区租客，存用户id
        MEMBER_USER_SET("memberUserSet"),                       // 小区成员，存用户id
        MASTER_USER_SET("masterUserSet"),                       // 小区户主，存用户id

        DOORBELL_SET("doorbellSet"),                            // 门口机，存设备id
        ENCLOSURE_SET("enclosureSet"),                          // 围墙机，存设备id
        CENTER_SET("centerSet"),                                // 中心机，存设备id

        ELDERLY_USER_SET("elderlyUserSet"),                     // 老年用户集合，存用户id
        MIDDLE_USER_SET("middleUserSet"),                       // 中年用户集合，存用户id
        YOUTH_USER_SET("youthUserSet"),                         // 青年用户集合，存用户id
        JUVENILE_USER_SET("juvenileUserSet"),                   // 少年用户集合，存用户id
        UNKNOWN_USER_SET("unknownUserSet"),                     // 未知用户集合，存用户id



        FOCUS_PASS_SET_NUM("focusPassSetNum"),                  // 今日重点布控人员、刑满释放通行数
        DISABILITY_PASS_SET_NUM("disabilityPassSetNum"),        // 今日残疾人通行数
        OLD_MAN_PASS_SET_NUM("oldManPassSetNum"),               // 今日老人通行数
        CHILD_PASS_SET_NUM("childPassSetNum"),                  // 今日小孩通行数
        GENERAL_USER_SET_NUM("generalUserSetNum"),              // 今日一般用户(没有标签的用户)通行数
        ACTIVE_USER_SET_NUM("activeUserSetNum"),                // 今日活跃用户数
        TENANT_USER_SET_NUM("tenantUserSetNum"),                // 小区租客数
        MEMBER_USER_SET_NUM("memberUserSetNum"),                // 小区成员数
        MASTER_USER_SET_NUM("masterUserSetNum"),                // 小区户主数

        DOORBELL_SET_NUM("doorbellSetNum"),                     // 门口机数
        ENCLOSURE_SET_NUM("enclosureSetNum"),                   // 围墙机数
        CENTER_SET_NUM("centerSetNum"),                         // 中心机数

        ELDERLY_USER_SET_NUM("elderlyUserSetNum"),              // 老年用户数
        MIDDLE_USER_SET_NUM("middleUserSetNum"),                // 中年用户数量
        YOUTH_USER_SET_NUM("youthUserSetNum"),                  // 青年用户数量
        JUVENILE_USER_SET_NUM("juvenileUserSetNum"),            // 少年用户数量
        CHILD_USER_SET_NUM("childUserSetNum"),                  // 儿童用户数量
        UNKNOWN_USER_SET_NUM("unknownUserSetNum"),              // 未知用户数量
        ;

        private String remark;
        CountTypeEnum(String remark) {
            this.remark = remark;
        }
        public String getRemark() { return remark; }
    }

    /**
     * 通过字符串获取枚举对象
     * @param remark
     * @return
     */
    public static CountTypeEnum getCountTypeEnum(String remark) {
        EnumSet<CountTypeEnum> countTypeEnumEnumSet = EnumSet.allOf(CountTypeEnum.class);
        for (CountTypeEnum c : countTypeEnumEnumSet) {
            if (c.getRemark().equals(remark)) {
                return c;
            }
        }

        return null;
    }


    /**
     * 获取用户信息 key
     * @param userId        [用户 id]
     */
    public static String getUserKey(String userId) {
        return String.format(PREFIX + "-%s-user", userId);
    }

    /**
     * 用于存放历史至今性的数据的 key
     * 户主/租客/成员 数量或用户id集合 | 实时通行人员数据
     */
    public static String getHistoryToNowData(String communityId, String fixedDate, CountTypeEnum countTypeEnum) {
        return String.format(COMPREHENSIVE_MANAGER_ACTUAL_ABOUT_COMMUNITY_KEY, communityId, fixedDate, countTypeEnum.getRemark());
    }


    /**
     * 获取有关小区的实时数据的 key
     * @param communityId    [小区 id]
     * @param localDateTime  [实时时间]
     * @param countTypeEnum  [统计类型]
     */
    public static String getActualDataAboutCommunityKey(String communityId, long localDateTime, CountTypeEnum countTypeEnum) {
        return String.format(COMPREHENSIVE_MANAGER_ACTUAL_ABOUT_COMMUNITY_KEY, communityId, TimeUtil.timeLong2yyyyMMddStr(localDateTime), countTypeEnum.getRemark());
    }
    /**
     * 获取有关楼栋的实时数据的 key
     * @param communityId    [小区 id]
     * @param localDateTime  [实时时间]
     * @param buildId        [楼栋 id]
     */
    public static String getActualDataAboutBuildKey(String communityId, long localDateTime, String buildId) {
        return String.format(COMPREHENSIVE_MANAGER_ACTUAL_ABOUT_BUILD_KEY, communityId, TimeUtil.timeLong2yyyyMMddStr(localDateTime), buildId, "buildData");
    }

    /**
     * 有关小区中相应门的开门总次数
     * @param communityId    [小区id]
     * @param localDateTime  [时间]
     */
    public static String getComprehensiveDeviceOpenTotalNumKey(String communityId, long localDateTime) {
        return String.format(COMPREHENSIVE_DEVICE_OPEN_TOTAL_NUM, communityId, TimeUtil.timeLong2yyyyMMddStr(localDateTime), CountTypeEnum.DEVICE_OPEN_TOTAL_NUM.getRemark());
    }
    /**
     * 相应门详细时间点的开门次数
     * @param communityId    [小区id]
     * @param doorId         [门id]
     * @param localDateTime  [时间]
     */
    public static String getComprehensiveDeviceOpenDetailedNumKey(String communityId, String doorId, long localDateTime) {
        return String.format(COMPREHENSIVE_DEVICE_OPEN_DETAILED_NUM, communityId, doorId, TimeUtil.timeLong2yyyyMMddStr(localDateTime), CountTypeEnum.DEVICE_OPEN_DETAILED_NUM.getRemark());
    }
    /**
     * 用于存放在 zset 时的 value 组装
     * @param buildId  [楼栋id]
     * @param doorId   [门id]
     */
    public static String getZsetValueStr(String buildId, String doorId) {
        String ZSET_VALUE = PREFIX + "-%s-%s";
        return String.format(ZSET_VALUE, buildId, doorId);
    }



    /**
     * 获取缓存用户的所有标签的 key
     * @param userId
     * @return
     */
    public static String getCacheAllTagOfUser(String userId) {
        return String.format(COMPREHENSIVE_ZZW_ALL_TAG_FOR_USER, userId, CountTypeEnum.CACHE_ALL_TAG_OF_USER.getRemark());
    }
    /**
     * 获取用户的 系统标签 和 在所在小区的自定义标签的集合 key
     * @param communityId
     * @param userId
     * @return
     */
    public static String getCacheTagOfCustomerAndSystemForUser(String communityId, String userId) {
        return String.format(COMPREHENSIVE_TAG_FOR_USER_ON_COMMUNITY, communityId, userId, CountTypeEnum.CACHE_TAG_OF_CUSTOMER_AND_SYSTEM_FOR_USER.getRemark());
    }
    /**
     * 获取有关存储标签的用户id的集合 key
     * @param communityId    [小区id]
     * @param tagId          [标签id]
     * @param localDateTime  [时间粒度]
     * @param countTypeEnum  [统计枚举]
     */
    public static String getTagUserMap(String communityId, Long tagId, long localDateTime, CountTypeEnum countTypeEnum) throws BizException {
        String demo = PREFIX + "-%s-%s-%s-%s";
        if (CountTypeEnum.TAG_COMMUNITY_THROUGH_MAP != countTypeEnum && CountTypeEnum.TAG_BUILD_THROUGH_MAP != countTypeEnum) {
            throw new BizException("500", "传入的统计类型枚举有误");
        }
        return String.format(demo, communityId, tagId, TimeUtil.timeLong2yyyyMMddStr(localDateTime), countTypeEnum.getRemark());
    }
    /**
     * 获取有关存储标签的人数的 hashKey
     * @param buildId         [楼栋id]
     * @param tagId           [标签id]
     */
    public static String getHashKeyForTagUserMap(String buildId, Long tagId) {
        String demo = PREFIX + "-%s-%s";
        buildId = StringUtils.isEmpty(buildId) ? UNKNOWN_BUILD_ID : buildId;
        return String.format(demo, buildId, tagId);
    }



}
