package com.zzwtec.third.aop.aspect.work;

import com.zzwtec.third.utils.BizException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

/**
 * create by Jomchen on 2018/12/4
 * 任务调度，由此列出大的任务块，其中调度任务细节
 */
@Component
public class WorkScheduling {

    @Autowired
    @Qualifier("webHandleWork")
    private WorkAbstract workAbstract;

    /**
     * 在 基本 aop 调用方法之前要做的事
     */
    public void baseBefore(ProceedingJoinPoint pjp) {
        workAbstract.choiceGenerateRequestId();
    }

    /**
     * 在 基本 aop 调用方法之后要做的事
     */
    public void baseFinally(ProceedingJoinPoint pjp) {
        workAbstract.removeRequestId();
    }

    /**
     * 有问题时返回错误信息的 json
     */
    public void handleError(BizException e) {
        workAbstract.handleError(e);
    }


    /**
     * 验证登录超时
     */
    public String checkTimeOut() {
        return workAbstract.checkTimeOut();
    }

}
