package com.zzwtec.third.aop.aspect.work;

import com.zzwtec.third.utils.BizException;

/**
 * create by Jomchen on 2018/12/4
 * aop任务细节，细节实现此抽象，并由 WorkScheduling 选择性调度
 */
public abstract class WorkAbstract {

    /**
     * 生成请求id ，并保存在上下文
     */
    public abstract void choiceGenerateRequestId();

    /**
     * 从上下文中，移除请求id
     */
    public abstract void removeRequestId();

    /**
     * 生成错误json信息返回到 web响应流中
     */
    public abstract void handleError(BizException e);

    /**
     * 验证登录超时
     */
    public abstract String checkTimeOut();


}
