package com.zzwtec.third.aop.aspect;

import com.zzwtec.third.aop.aspect.work.WorkScheduling;
import com.zzwtec.third.utils.BizException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

/**
 * create by Jomchen on 2018/12/4
 * 基本 AOP ，任务块由 WorkScheduling 调度
 */
@Order(AopOrder.BASE_ORDER)
@Component
@Aspect
public class ControllerAop {

    private Logger logger = LoggerFactory.getLogger(ControllerAop.class);

    @Autowired
    private WorkScheduling workScheduling;

    @Around("execution(public * com.zzwtec.third.action..*.*(..))")
    public Object handleBase(ProceedingJoinPoint pjp) {

        Object result;
        try {
            workScheduling.baseBefore(pjp);
            String timeOutUrl = workScheduling.checkTimeOut();
            if (null != timeOutUrl) { return timeOutUrl; }

            result = pjp.proceed();
        } catch (BizException e) {
            logger.warn(e.getMessage());
            workScheduling.handleError(e);
            return null;
        } catch (Throwable e) {
            logger.error(e.getMessage(), e.getCause());
            workScheduling.handleError(null);
            return null;
        } finally {
            workScheduling.baseFinally(pjp);
        }

        return result;
    }

}
