package com.zzwtec.third.action.community;

import com.alibaba.fastjson.TypeReference;
import com.zzwtec.third.common.*;
import com.zzwtec.third.config.redis.RedisService;
import com.zzwtec.third.model.SysuserCache;
import com.zzwtec.third.model.information.dto.NoticeDTO;
import com.zzwtec.third.services.NoticeServiceImpl;
import com.zzwtec.third.utils.BizException;
import com.zzwtec.third.utils.ErrorCode;
import com.zzwtec.third.utils.ResultJsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * create by Jomchen on 2018/12/7
 */
@Controller
public class AdmNoticeController {

    private Logger logger = LoggerFactory.getLogger(AdmNoticeController.class);

    @Autowired
    private NoticeServiceImpl noticeService;
    @Autowired
    private HttpServletResponse response;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private RedisService redisService;

    /**
     * 根据小区id 查询资讯列表
     */
    @RequestMapping(
            value = UrlContents.NEWS_QUERY_NOTICE_BY_COMMUNITYID
    )
    public String queryNoticeByCommunityId(
            @ModelAttribute("noticeDTO")NoticeDTO noticeDTO) {

        String tokenId = TokenServiceSupport.getWebTokenIdFromCookie(request);
        SysuserCache sysuserCache = redisService.getEntity(
                tokenId,
                new TypeReference<SysuserCache>() {}
        );

        if (null == noticeDTO.getPage() || noticeDTO.getPage() <= 0) {
            noticeDTO.setPage(Page.DEFAULT_PAGE);
        }
        if (null == noticeDTO.getPageNum() || noticeDTO.getPageNum() <= 0) {
            noticeDTO.setPageNum(Page.DEFAULT_PAGE_NUM);
        }
        String currentCommunityId = sysuserCache.getCurrentManageCommunity().getId();
        noticeDTO.setCommunityId(currentCommunityId);

        try {
            Page<NoticeDTO> page = noticeService.queryNoticeByCommunityId(noticeDTO);
            request.setAttribute("pageList", page.getData());
            PageIndexHelper.setPaging(request, page);
        } catch (BizException e) {
            logger.warn(e.getMessage(), e.getCause());
            DataObject repJson = new DataObject(e.getCode(), e.getMessage());
            ResultJsonUtil.renderJson(response, repJson);
            return null;
        } catch (Exception e) {
            logger.warn(e.getMessage(), e.getCause());
            DataObject repJson = new DataObject(
                    ErrorCode.ERROR_A_NEGATIVE.getCode(),
                    ErrorCode.ERROR_A_NEGATIVE.getMessage()
            );
            ResultJsonUtil.renderJson(response, repJson);
            return null;
        }

        return "/community/information/view/notice_list.html";
    }

    /**
     * 根据资讯id 查询资讯详情
     */
    @RequestMapping(
            value = UrlContents.NEWS_NEWS_QUERY_NOTICE_BY_NOTICEID,
            method = RequestMethod.POST
    )
    public String queryNoticeByNoticeId(String noticeId) {

        try {
            NoticeDTO noticeDTO = noticeService.queryNoticeByNoticeId(noticeId);
            request.setAttribute("notice", noticeDTO);
        } catch (BizException e) {
            logger.warn(e.getMessage(), e.getCause());
            DataObject repJson = new DataObject(e.getCode(), e.getMessage());
            ResultJsonUtil.renderJson(response, repJson);
            return null;
        } catch (Exception e) {
            logger.warn(e.getMessage(), e.getCause());
            DataObject repJson = new DataObject(
                    ErrorCode.ERROR_A_NEGATIVE.getCode(),
                    ErrorCode.ERROR_A_NEGATIVE.getMessage()
            );
            ResultJsonUtil.renderJson(response, repJson);
            return null;
        }

        return "/community/information/view/notice_info.html";
    }

}
