package com.zzwtec.third.action.common;

import com.alibaba.fastjson.TypeReference;
import com.zzwtec.third.common.*;
import com.zzwtec.third.config.redis.RedisService;
import com.zzwtec.third.model.SysuserCache;
import com.zzwtec.third.model.basedata.dto.BuildDTO;
import com.zzwtec.third.model.basedata.dto.CommunityDTO;
import com.zzwtec.third.model.basedata.dto.QueryBuildDTO;
import com.zzwtec.third.services.BuildServiceImpl;

import com.zzwtec.third.utils.BizException;
import com.zzwtec.third.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 公共回填列表
 * 包括小区，楼栋，房间
 * 如果可以不加修改的调用该类中的方法尽量调用，
 * 如果需要修改才能满足需求，则尽量新建方法 
 * @author yangtonggan
 * @date 2016-3-30
 *
 */
@Controller
public class CommonBackfillController {

	private Logger logger = LoggerFactory.getLogger(CommonBackfillController.class);

	@Autowired
	@Qualifier("stringRedisTemplate")
	private RedisTemplate<String, String> stringRedisTemplate;
	@Autowired
	private RedisService redisService;
	@Autowired
	private VerifyCodeComponent verifyCodeComponent;
	@Autowired
	private HttpServletResponse response;
	@Autowired
	private HttpServletRequest request;
	@Autowired
	private BuildServiceImpl buildServiceImpl;


	/**
	 *获取楼栋列表 单选回填
	 *
	 */
	@RequestMapping(UrlContents.URL_ADMCOMMON_BUILD_BACKFILL_RADIO)
	public String buildListBackfill(){
		queryBuild();
		return "/community/common/view/build_backfill_radio_list.html";
	}

	public void queryBuild(){
		response.setCharacterEncoding("utf-8");
		// 获取当前管理的小区Id
		String token = TokenServiceSupport.getWebTokenIdFromCookie(this.request);
		SysuserCache sysuserCache = redisService.getEntity(token, new TypeReference<SysuserCache>() {});
		CommunityDTO currentManageCommunity = sysuserCache.getCurrentManageCommunity();
		// 获取当前页
		String page = request.getParameter("page");
		Integer currentPage = 1;
		if (StringUtil.notEmpty(page)) {
			try {
				currentPage = Integer.parseInt(page);
			} catch (Exception e) {
			}
		}
		// 封装参数
		QueryBuildDTO queryBuildDTO = new QueryBuildDTO();
		queryBuildDTO.setCommunityId(currentManageCommunity.getId());
		queryBuildDTO.setPage(currentPage);
		queryBuildDTO.setToken(token);
		queryBuildDTO.setPageNum(Pageing.PAGE_SIZE);

		// 处理响应页面
		Page<BuildDTO> buildPage = new Page<BuildDTO>();
		try {
			buildPage = buildServiceImpl.queryBuildByCommunityId(queryBuildDTO);
			if (buildPage == null) {
				logger.error("获取楼栋分页信息失败");
			} else {
				request.setAttribute("pageList", buildPage.getData());
			}
		} catch (BizException e) {
			logger.error("获取楼栋分页信息失败", e);
		}
		buildPage.setPage(currentPage);
		buildPage.setPageNum(Pageing.PAGE_SIZE);
		PageIndexHelper.setPaging(this.request, buildPage);
	}





}
