package com.zzwtec.jdbc.service;

import com.zzwtec.jdbc.dao.ThirdUserWechatDao;
import com.zzwtec.jdbc.entity.ThirdUserWechat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * create by Jomchen on 2018/12/18
 */
@Service
public class ThirdUserWechatService {

    @Autowired
    ThirdUserWechatDao thirdUserWechatDao;

    @Transactional
    public int add(ThirdUserWechat thirdUserWechat) {
        return thirdUserWechatDao.add(thirdUserWechat);
    }

    @Transactional
    public int deleteById(String id) {
        return thirdUserWechatDao.deleteById(id);
    }

    /**
     * 根据微信openid查询微信用户信息
     *
     * @author wxy
     */
    public ThirdUserWechat queryUserWechatByOpenid(String openid) {
        return thirdUserWechatDao.queryUserWechatByOpenid(openid);
    }

    /**
     * 根据微信openid和用户手机号物理删除用户微信信息
     *
     * @author wxy
     */
    public int deleteByOpenidAndPhone(String openid, String phone) {
        return thirdUserWechatDao.deleteByOpenidAndPhone(openid, phone);
    }

    /**
     * 根据微信用户openid修改微信用户信息是否逻辑删除
     *
     * @author wxy
     */
    public int modifyUserWechatDeletec(String openid, boolean isDeletec) {
        return thirdUserWechatDao.modifyUserWechatDeletec(openid, isDeletec);
    }

    //根据userid集合查询微信用户集合
    public List<ThirdUserWechat> queryUserWechatByUserIds(List<String> userIds) {
        String[] userids=new String[userIds.size()];
        for(int i=0;i<userIds.size();i++){
            userids[i]=userIds.get(i);
        }
//        String[] userids=(String[])userIds.toArray();

        return thirdUserWechatDao.queryUserWechatByUserIds(userids);
    }

}
