package com.zzwtec.jdbc.dao;

import com.zzwtec.jdbc.entity.ThirdUserWechat;
import com.zzwtec.third.utils.TimeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;

/**
 * create by Jomchen on 2018/12/18
 */
@Repository
public class ThirdUserWechatDao extends BaseDao<ThirdUserWechat> {

    @Autowired
    private JdbcTemplate jdbcTemplate;

    final String COLUMN_SQL = " id, openid, phone, user_id, deletec, remark, create_time, update_time ";

    final String TABLE_NAME = "third_user_wechat";

    public int add(ThirdUserWechat bean) {
        long nowTime = TimeUtil.getNowTime();
        String sql = "INSERT INTO " + TABLE_NAME + "(" + COLUMN_SQL + ") VALUES(?,?,?,?,?,?,?,?)";
        return jdbcTemplate.update(
                sql,
                bean.getId(), bean.getOpenid(), bean.getPhone(), bean.getUserId(),
                bean.getDeletec(), bean.getRemark(), nowTime, nowTime
        );
    }

    public int deleteById(String id) {
        return deleteById(TABLE_NAME, id);
    }

    /**
     * 根据微信openid查询微信用户信息
     *
     * @author wxy
     */
    public ThirdUserWechat queryUserWechatByOpenid(String openid) {
        String sql = "SELECT * FROM third_user_wechat WHERE openid = ? AND deletec = ?";
        try {
            return jdbcTemplate.queryForObject(sql, new ThirdUserWechatMapper(), openid, false);
        } catch (EmptyResultDataAccessException e) {
            return null;
        }
    }
    public List<ThirdUserWechat> queryUserWechatByUserIds(String[] userIds) {
        if(userIds==null || userIds.length==0)return null;
        String sql = "SELECT * FROM third_user_wechat WHERE user_id in  ("+getSqlInStr(userIds.length)+") AND deletec =0";
        try {
            return super.selectList(sql,userIds, new ThirdUserWechatMapper());
        } catch (EmptyResultDataAccessException e) {
            return null;
        }

    }

    /**
     * 根据微信openid和用户手机号物理删除用户微信信息
     *
     * @author wxy
     */
    public int deleteByOpenidAndPhone(String openid, String phone) {
        String sql = "DELETE FROM third_user_wechat WHERE openid = ? AND phone = ?";
        int update = jdbcTemplate.update(sql, openid, phone);
        return update;
    }

    /**
     * 根据微信用户openid修改微信用户信息是否逻辑删除
     *
     * @author wxy
     */
    public int modifyUserWechatDeletec(String openid, boolean isDeletec) {
        String sql = "UPDATE third_user_wechat SET deletec = ?, update_time = ? WHERE openid = ?";
        return update(sql, isDeletec, TimeUtil.getNowTime(), openid);
    }
}

class ThirdUserWechatMapper implements RowMapper<ThirdUserWechat> {
    @Override
    public ThirdUserWechat mapRow(ResultSet rs, int i) throws SQLException {
        ThirdUserWechat bean = new ThirdUserWechat();
        bean.setId(rs.getString("id"));
        bean.setOpenid(rs.getString("openid"));
        bean.setPhone(rs.getString("phone"));
        bean.setUserId(rs.getString("user_id"));
        bean.setDeletec(rs.getBoolean("deletec"));
        bean.setRemark(rs.getString("remark"));
        bean.setCreateTime(rs.getLong("create_time"));
        bean.setUpdateTime(rs.getLong("update_time"));
        return bean;
    }
}
