package com.zzwtec;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.zzwtec.wechat.config.WeChatConfig;
import okhttp3.OkHttpClient;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;

/**
 * create by Jomchen on 2018/11/29
 */
@SpringBootApplication
public class ThirdServiceTemplateApplication {

    @Bean
    public HttpMessageConverters fastJsonHttpMessageConverters() {
        FastJsonHttpMessageConverter fastConverter = new FastJsonHttpMessageConverter();
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        fastJsonConfig.setSerializerFeatures(SerializerFeature.PrettyFormat);
        fastConverter.setFastJsonConfig(fastJsonConfig);
        fastConverter.setSupportedMediaTypes(Arrays.asList(MediaType.APPLICATION_JSON_UTF8));
        return new HttpMessageConverters((HttpMessageConverter<?>) fastConverter);
    }

    public static void main(String[] args) {
        SpringApplication.run(ThirdServiceTemplateApplication.class, args);
    }

    @ConfigurationProperties(prefix = "weChat")
    public @Bean(initMethod = "init",destroyMethod = "destroy") WeChatConfig weChatConfig(){
        return new WeChatConfig();
    }


    //创建okHttp客户端
    public @Bean
    OkHttpClient okHttpClient() {
        return new OkHttpClient.Builder()
                .connectTimeout(60000, TimeUnit.SECONDS)
                .readTimeout(120000, TimeUnit.SECONDS)
                .build();
    }


    /**
	 * 配置默认错误页面（仅用于内嵌tomcat启动时）
	 * 使用这种方式，在打包为war后不起作用
	 */
//    @Bean
//    public WebServerFactoryCustomizer<ConfigurableWebServerFactory> webServerFactoryCustomizer() {
//        return factory -> {
//            ErrorPage error404Page = new ErrorPage(HttpStatus.NOT_FOUND, "/404.html");
//            ErrorPage error500Page = new ErrorPage(HttpStatus.INTERNAL_SERVER_ERROR, "/500.html");
//            factory.addErrorPages(error404Page);
//            factory.addErrorPages(error500Page);
//        };
//    }
}
